<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-pencil me-2"></i>Edit Organisasi
    </h2>
    <a href="<?= base_url('admin/organizations') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/organizations/update/' . $organization['id']) ?>" method="POST">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_organisasi" class="form-label">Nama Organisasi <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_organisasi" name="nama_organisasi" 
                       value="<?= old('nama_organisasi', $organization['nama_organisasi']) ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="jabatan" class="form-label">Jabatan</label>
                <input type="text" class="form-control" id="jabatan" name="jabatan" 
                       value="<?= old('jabatan', $organization['jabatan'] ?? '') ?>" placeholder="Contoh: Ketua, Anggota, dll">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
                <input type="number" class="form-control" id="tahun_mulai" name="tahun_mulai" 
                       value="<?= old('tahun_mulai', $organization['tahun_mulai'] ?? '') ?>" min="1900" max="2100" placeholder="Contoh: 2020">
            </div>
            <div class="col-md-4 mb-3">
                <label for="tahun_selesai" class="form-label">Tahun Selesai</label>
                <input type="number" class="form-control" id="tahun_selesai" name="tahun_selesai" 
                       value="<?= old('tahun_selesai', $organization['tahun_selesai'] ?? '') ?>" min="1900" max="2100" placeholder="Contoh: 2023">
            </div>
            <div class="col-md-4 mb-3">
                <label for="urutan" class="form-label">Urutan</label>
                <input type="number" class="form-control" id="urutan" name="urutan" 
                       value="<?= old('urutan', $organization['urutan'] ?? 0) ?>" min="0">
            </div>
        </div>

        <div class="mb-3">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            
            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                      placeholder="Tulis deskripsi atau klik Generate AI untuk membuat otomatis..."><?= old('deskripsi', $organization['deskripsi'] ?? '') ?></textarea>
            
            <!-- AI Generate Button -->
            <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
                    style="top: 35px; right: 10px; z-index: 10;" 
                    id="generateDescriptionBtn" onclick="generateOrganizationDescription()">
                <i class="bi bi-magic" id="generateIcon"></i>
                <span id="generateText">Generate AI</span>
            </button>
            
            <!-- AI Status -->
            <div class="ai-status mt-2" id="aiStatus" style="display: none;">
                <div class="alert alert-info alert-sm">
                    <i class="bi bi-robot me-1"></i>
                    <span id="aiStatusText">Sedang menggenerate deskripsi...</span>
                </div>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Update
            </button>
            <a href="<?= base_url('admin/organizations') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>

<script src="<?= base_url('assets/js/ai-generator.js') ?>"></script>
<script>
// Initialize AI Generator UI for Organizations Edit
document.addEventListener('DOMContentLoaded', function() {
    // Auto-fill AI input when nama_organisasi changes
    const namaOrganisasi = document.getElementById('nama_organisasi');
    if (namaOrganisasi) {
        namaOrganisasi.addEventListener('input', function() {
            const aiInput = document.getElementById('aiInput');
            if (aiInput && this.value) {
                aiInput.value = `Saya terlibat dalam organisasi "${this.value}". Tolong buatkan deskripsi tentang peran dan kontribusi saya dalam organisasi ini.`;
            }
        });
    }
});
</script>


